/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.entities.CreepingHorror;
import OreSpawn.entities.TerribleTerror;
import dangerzone.DangerZone;
import dangerzone.Effects;
import dangerzone.Player;
import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.RenderInfo;
import dangerzone.entities.TargetHelper;
import dangerzone.items.Items;
import java.util.Properties;
import org.newdawn.slick.opengl.Texture;

public class Nightmare
extends EntityLiving {
    float myspeed = 0.0f;
    public RenderInfo renderdata = new RenderInfo();

    public Nightmare(World w) {
        super(w);
        this.maxrenderdist = 200;
        this.uniquename = "OreSpawn:Nightmare";
        if (w != null) {
            this.myspeed = 0.25f + this.world.rand.nextFloat() * 0.25f;
        }
        this.takesFallDamage = false;
        this.movefrequency = 65;
        this.canSwim = true;
        this.temperament = 1;
        this.enable_hostile = true;
        this.daytimespawn = false;
        this.daytimedespawn = true;
        this.nighttimespawn = true;
        this.nighttimedespawn = false;
        float t = 0.5f;
        if (DangerZone.rand.nextInt(4) == 1) {
            t = 1.0f;
        }
        if (DangerZone.rand.nextInt(8) == 2) {
            t = 2.0f;
        }
        if (DangerZone.rand.nextInt(32) == 3) {
            t = 3.0f;
        }
        if (DangerZone.rand.nextInt(64) == 4) {
            t = 4.0f;
        }
        if (w == null) {
            t = 0.5f;
        }
        this.setVarFloat(21, t);
        this.setExperience((int)(200.0f * t));
        this.height = 3.75f * t;
        this.width = 2.75f * t;
        this.setMaxHealth(200.0f * t);
        this.setHealth(200.0f * t);
        this.setDefense(2.0f + t);
        this.setAttackDamage(60.0f * t);
        this.searchDistance = 16.0f + 8.0f * t;
        this.attackRange = 4.0f + t;
        this.canFly = true;
        this.tower_defense_enable = true;
    }

    public void init() {
        super.init();
        float t = this.getNightmareScale();
        this.height = 3.75f * t;
        this.width = 2.75f * t;
        this.setMaxHealth(200.0f * t);
        this.setDefense(2.0f + t);
        this.setAttackDamage(60.0f * t);
        this.searchDistance = 16.0f + 8.0f * t;
        this.attackRange = 4.0f + t;
        this.setExperience((int)(200.0f * t));
    }

    public void doAttackFrom(Entity e, int dt, float pain) {
        this.setFlying(true);
        super.doAttackFrom(e, dt, pain);
    }

    public void doAttack(Entity victim) {
        Effects ef = new Effects(7, 2.0f, 100);
        victim.addEffectFromServer(ef);
        super.doAttack(victim);
    }

    public float getNightmareScale() {
        float t = this.getVarFloat(21);
        if (t == 0.0f) {
            t = 0.5f;
        }
        return t;
    }

    public void writeSelf(Properties prop, String tag) {
        super.writeSelf(prop, tag);
        prop.setProperty(String.format("%s%s", tag, "Fscale"), String.format("%f", Float.valueOf(this.getNightmareScale())));
    }

    public void readSelf(Properties prop, String tag) {
        super.readSelf(prop, tag);
        float t = Utils.getPropertyFloat((Properties)prop, (String)String.format("%s%s", tag, "Fscale"), (float)0.5f, (float)5.1f, (float)0.5f);
        this.setVarFloat(21, t);
    }

    public void doEntityAction(float deltaT) {
        if (this.target == null) {
            this.target = new TargetHelper(this.posx, this.posy, this.posz);
        }
        if (this.isSwarming()) {
            this.setFlying(false);
            this.setFlying(true);
        }
        if (!this.isFlying()) {
            super.doEntityAction(deltaT);
            if (this.world.rand.nextInt(1000) == 1) {
                this.setFlying(true);
            }
            return;
        }
        ++this.searchcounter;
        if (this.searchcounter >= 10) {
            this.searchcounter = this.world.rand.nextInt(4);
            if (this.hurtMe != null && this.hurtMe.deadflag) {
                this.hurtMe = null;
            }
            if (this.world.rand.nextInt(50) == 1) {
                this.hurtMe = null;
            }
            this.targetentity = this.hurtMe;
            if (this.targetentity == null) {
                this.targetentity = this.findSomethingToAttack();
            }
            if (this.targetentity != null) {
                this.target = new TargetHelper(this.targetentity, this.targetentity.posx, this.targetentity.posy + (double)(this.targetentity.getHeight() * 3.0f / 4.0f), this.targetentity.posz);
                this.setAttacking(true);
            } else {
                this.setAttacking(false);
            }
        }
        if (this.targetentity != null && this.world.rand.nextInt(10) == 1 && this.getDistanceFromEntity(this.targetentity) < (double)(this.attackRange + this.targetentity.getWidth() / 2.0f + this.getWidth() / 2.0f)) {
            float dmg = this.getAttackDamage();
            int dt = 4;
            this.targetentity.doAttackFrom((Entity)this, dt, dmg);
        }
        this.doLookAction();
        if (!(this.isHurt() || this.deadflag || this.getStaying() || this.world.rand.nextInt(100) != 1)) {
            this.world.playSound(this.getLivingSound(), this.dimension, this.posx, this.posy + (double)(this.getHeight() / 2.0f), this.posz, this.getLivingSoundVolume(), this.getLivingSoundPitch());
        }
        int keep_trying = 25;
        this.do_swarm_despawn();
        int bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz);
        if (bid == 0 && this.wouldBump(this.posx + (double)(this.motionx * deltaT), this.posy + (double)(this.motiony * deltaT) + (double)(this.getHeight() / 2.0f), this.posz + (double)(this.motionz * deltaT), this.getWidth())) {
            bid = 1;
        }
        if (bid != 0 || this.world.rand.nextInt(50) == 1 || this.target.getDistanceToTarget(this.posx, this.posy, this.posz) < 2.0) {
            int updown = 5;
            int k = 1;
            while ((float)k < 12.0f + this.getNightmareScale()) {
                bid = this.world.getblock(this.dimension, (int)this.posx, (int)this.posy - k, (int)this.posz);
                if (bid != 0) {
                    updown = -1;
                    break;
                }
                ++k;
            }
            bid = 1;
            while (bid != 0 && keep_trying != 0) {
                if (this.isSwarming()) {
                    this.target.setTarget(this.posx + (double)this.world.rand.nextInt(15) + (double)((int)(this.getNightmareScale() * 5.0f)), this.posy + (double)(this.world.rand.nextInt(7) - updown), this.posz + (double)this.world.rand.nextInt(15) + (double)((int)(this.getNightmareScale() * 5.0f)));
                } else {
                    this.target.setTarget(this.posx + (double)(this.world.rand.nextInt(25 + (int)(this.getNightmareScale() * 5.0f)) - this.world.rand.nextInt(25 + (int)(this.getNightmareScale() * 5.0f))), this.posy + (double)(this.world.rand.nextInt(8) - updown), this.posz + (double)(this.world.rand.nextInt(25 + (int)(this.getNightmareScale() * 5.0f)) - this.world.rand.nextInt(25 + (int)(this.getNightmareScale() * 5.0f))));
                }
                bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz);
                if (bid == 0 && !this.CanProbablySee(this.dimension, this.target.targetx, this.target.targety, this.target.targetz, (int)Math.sqrt((this.posx - this.target.targetx) * (this.posx - this.target.targetx) + (this.posz - this.target.targetz) * (this.posz - this.target.targetz) + (this.posy - this.target.targety) * (this.posy - this.target.targety)))) {
                    bid = 1;
                }
                --keep_trying;
                this.myspeed = 0.25f + this.world.rand.nextFloat() * 0.25f;
                if (this.getNightmareScale() > 0.5f) {
                    this.myspeed += this.world.rand.nextFloat() * 0.15f;
                }
                if (this.getNightmareScale() > 1.0f) {
                    this.myspeed += this.world.rand.nextFloat() * 0.15f;
                }
                if (this.getNightmareScale() > 2.0f) {
                    this.myspeed += this.world.rand.nextFloat() * 0.15f;
                }
                if (!(this.getNightmareScale() > 3.0f)) continue;
                this.myspeed += this.world.rand.nextFloat() * 0.15f;
            }
        }
        if ((bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz)) != 0) {
            this.target.setTarget(this.posx + (double)(this.world.rand.nextInt(5) - this.world.rand.nextInt(5)), this.posy + (double)(this.world.rand.nextInt(5) + 3), this.posz + (double)(this.world.rand.nextInt(5) - this.world.rand.nextInt(5)));
        }
        float dy = (float)(this.target.targety - this.posy);
        this.motiony += 0.12f * deltaT;
        if ((dy /= 20.0f) > 0.2f) {
            dy = 0.2f;
        }
        if (dy < -0.2f) {
            dy = -0.2f;
        }
        this.motiony += dy;
        if (this.motiony > 1.0f) {
            this.motiony = 1.0f;
        }
        if (this.motiony < -1.0f) {
            this.motiony = -1.0f;
        }
        float cdir = (float)Math.toRadians(this.rotation_yaw);
        float tdir = (float)Math.atan2(this.target.targetx - this.posx, this.target.targetz - this.posz);
        float ddiff = tdir - cdir;
        while ((double)ddiff > Math.PI) {
            ddiff = (float)((double)ddiff - Math.PI * 2);
        }
        while ((double)ddiff < -Math.PI) {
            ddiff = (float)((double)ddiff + Math.PI * 2);
        }
        this.rotation_yaw_motion = (float)((double)this.rotation_yaw_motion + (double)(ddiff * 180.0f) / Math.PI / 10.0);
        float speedadjust = 1.0f;
        float effectspeed = this.getTotalEffect(1);
        if (effectspeed > 1.0f) {
            speedadjust *= effectspeed;
        }
        if ((effectspeed = this.getTotalEffect(2)) > 1.0f) {
            speedadjust /= effectspeed;
        }
        this.motionx = (float)((double)this.motionx + (double)(this.myspeed * speedadjust) * Math.sin(tdir) * (double)deltaT);
        this.motionz = (float)((double)this.motionz + (double)(this.myspeed * speedadjust) * Math.cos(tdir) * (double)deltaT);
        Utils.SpawnDustAlongPath((EntityLiving)this);
        if (!this.isSwarming() && this.world.rand.nextInt(4000) == 1) {
            this.setFlying(false);
        }
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof Nightmare) {
            return false;
        }
        if (e instanceof CreepingHorror) {
            return false;
        }
        if (e instanceof TerribleTerror) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player;
    }

    public void doDeathDrops() {
        int howmany = 1 + this.world.rand.nextInt(4);
        howmany += (int)this.getNightmareScale();
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.goosemeat.itemID, (float)(this.getNightmareScale() * 2.0f), (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = 1 + this.world.rand.nextInt(4);
        howmany += (int)this.getNightmareScale();
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.feather.itemID, (float)(this.getNightmareScale() * 2.0f), (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = 2 + (int)this.getNightmareScale();
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.zookeepershard.itemID, (float)(this.getNightmareScale() * 2.0f), (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.nightmarescale.itemID, (float)(this.getNightmareScale() * 2.0f), (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        if (this.world.rand.nextInt(5) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophynightmare.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        super.doDeathDrops();
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/Nightmaretexture.png");
        }
        return this.texture;
    }

    public String getHurtSound() {
        return "OreSpawn:nightmare_hit";
    }

    public String getDeathSound() {
        return "OreSpawn:nightmare_dead";
    }

    public String getLivingSound() {
        if (this.world.rand.nextInt(2) != 1) {
            return null;
        }
        return "OreSpawn:nightmare_living";
    }
}

